import QtQuick 2.3
import QtGraphicalEffects 1.0
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {

    Camera {
        property string name: "camera"
        x: sync(name + ".x"); y: sync(name + ".y"); z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX"); lookAtY: sync(name + ".lookAtY"); lookAtZ: sync(name + ".lookAtZ")
        upX: sync("camera.upX"); upY: sync("camera.upY"); upZ: sync("camera.upZ")
    }

    // setup default textures
    TextureImage { textureUnit: 1;
        file: "../../images/_SK57414_normal.png"
    }
    TextureImage { textureUnit: 2;
        file: "../../images/area_lights.jpg"
    }
    Texture { textureUnit: 3; textureRT: "prev" }
    Texture { textureUnit: 4; textureRT: "prevBlur" }
    Texture { textureUnit: 5; textureRT: "prevNormal" }


    // draw the big mirror plane / background mesh
    Shader { file: "smPlastic" }
    TextureImage { textureUnit: 0;
        // file: "../../images/scratch1.png"
        file: "../../images/meteor_b.png"
    }
    DrawMesh {
        Clear { cR: 0.0; cG: 0.0; cB: 0.0 }
        file: "mesh/box1m.lwo"
        smoothNormals: true; normalSmoothAngle: 20

        Pos { x: 0.0; y: -.50; z: 0.0; }
        Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }
        Sca { s: 4.00; x: 100.0; y: 1.0; z: 100.0 }

        ShaderParam { paramName: "g_uvScale"; paramValue: 0.00}
        ShaderParam { paramName: "g_texBrightness"; paramValue: 2.0 }
        ShaderParam { paramName: "g_bump"; paramValue: 0.0}
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount") }
        ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0" }

        blendMode: "off"
        depthTest: true; depthWrite: true
        cull: true; cullBack: true
    }

    // shaderVaryings define the transform feedback emit and input vertex data structure
    property string shaderVaryings: "
        vec3 posG;
        vec3 normalG;
        vec2 uvG;
        vec3 tangentG;"
    Shader {
        file: "transKoe"; tfVaryings: shaderVaryings;
        ShaderParam { paramName: "g_emit"; paramValue: 0.0}
    }
    // start drawing (with transform feedback) triangles to sceneName+"trans" named vertex buffer object (vbo)
    // all Draw* after this and before "drawStop" has the render to the screen disabled (goes only to the vertex buffer)
    DrawVB {
        type: "drawStart"; primType: "triangles"; vboId: sceneName+"trans"; tfVaryings: shaderVaryings;
        reset: sync("trans.reset")
        onResetChanged: {if (reset > 0.5) resetParticles();}
        gridWidth: 1000; gridHeight: 1000
        drawNumPoints: gridWidth*gridHeight
        depthTest: false; depthWrite: false
    }

    property real ti: demoTime()
    property real prevTi: 0.0
    property real ki: 0.0
    property real kii: 0.0
    onTiChanged: {
        ki += (ti-prevTi)*sync("emitTrack.freq");
        kii += (ti-prevTi)*sync("emitTrack.freq")*sync("emitTrack.innerFreq");
        prevTi = ti;
    }

    property real pr: sync("emitTrack.innerRad")
    property real er: sync("emitTrack.rad")
    property int drawIndex: 0
    Connections { target: demo; onFrameRendered: { drawIndex++; } }

    // draw one bigger mesh to the vbo (per frame)
    DrawMesh {
        property string name: "meshxxx"
        //file: (drawIndex%10 < 9) ? "mesh/box1m.lwo" : "mesh/ball5000.x"
        file: (drawIndex%10 < 9) ? "mesh/dode.lwo" : "mesh/ball5000.x"
        //  file: "mesh/dode.lwo"
         // file: "mesh/toroid.lwo"
         // file: "mesh/rinkula.obj"

        Pos { x: er*Math.sin(ki)+pr*Math.cos(kii*2.3); y: Math.abs(0.0*(Math.sin(ki*0.9+Math.cos(ki*1.5)))); z: er*Math.cos(ki)+pr*Math.sin(kii*3.43); }
        Rot { d: demoTime()*0.0; ax: 1.0; ay: 1.0; az: 0.0 }

        //Sca { s: 0.080; x: 1.0; y: 6.0+5.0*Math.sin(ki*9.3); z: 1.0 }
        Sca { s: 0.080; x: 1.0; y: 1.0; z: 1.0 }

        Pos { y: 0.50 }
        ShaderParam { paramName: "g_emit"; paramValue: 1.0}
        ShaderParam { paramName: "g_uvScale"; paramValue: 2.0}
        blendMode: "off"
        depthTest: true; depthWrite: true
    }

    // draw one smaller mesh to the vbo (per frame)
    DrawMesh {
        property string name: "meshxxx"
        file: (drawIndex%10 < 9) ? "mesh/box1m.lwo" : "mesh/ball5000.x"
      //  file: "mesh/dode.lwo"
       // file: "mesh/toroid.lwo"
       // file: "mesh/rinkula.obj"

        Pos { x: er*Math.sin(ki)+pr*Math.cos(kii*2.3); y: 0.08+Math.abs(0.0*(Math.sin(ki*0.9+Math.cos(ki*1.5)))); z: er*Math.cos(ki)+pr*Math.sin(kii*3.43); }
        Rot { d: demoTime()*0.0; ax: 1.0; ay: 1.0; az: 0.0 }

        //Sca { s: 0.080; x: 1.0; y: 6.0+5.0*Math.sin(ki*9.3); z: 1.0 }
        Sca { s: 0.020; x: 1.0; y: 1.0; z: 1.0 }

        Pos { y: 0.50 }
        ShaderParam { paramName: "g_emit"; paramValue: 1.0}
        ShaderParam { paramName: "g_uvScale"; paramValue: 2.0}
        blendMode: "off"
        depthTest: true
        depthWrite: true

    }

    // start drawing to the vertex buffer (with transform feedback)
    DrawVB {
        type: "drawStop"; vboId: sceneName+"trans"; tfVaryings: shaderVaryings
        gridWidth: 1000; gridHeight: 1000; drawNumPoints: gridWidth*gridHeight
    }

    // draw the vbo to the screen
    TextureImage {
        textureUnit: 0
        //file: "../../images/scratch1.png"
        file: "../../images/meteor_b.png"
    }
    Shader { file: "smPlastic" }
    DrawVB {
        enabled: true
        type: "pointGridDraw"
        vboId: sceneName+"trans"
        tfVaryings: shaderVaryings
        primType: "triangles"
        gridWidth: 1000; gridHeight: 1000
        drawNumPoints: gridWidth*gridHeight
        depthTest: true; depthWrite: true
        ShaderParam { paramName: "g_bump"; paramValue: 0.0}
        ShaderParam { paramName: "g_texBrightness"; paramValue: 3.0 }
        ShaderParam { paramName: "g_uvScale"; paramValue: 1.0 }
        ShaderParam { paramName: "g_color"; paramValueVec4: "1.40, 1.20, 1.0" }
        Pos { x: 0.0; y: 0.0; z: 0.0 }
        Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }
        Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
        blendMode: "off"
        onParticleCountChanged: {
            triangleCountText.text = "triangle count:"+particleCount
        }
    }


    Blit { textureRT: "depth"; blitRT: 1 }
    Reflect {}
    Blit { textureRT: "prev" }
    Tonemap {}
    Vignette {}
    Coords {}

    // draw the debug info overlay text (triangle counts etc...)
    Item {
        visible: bDebugTexts
        enabled: bDebugTexts
        id: infoText
        layer.enabled: true
        width: 1280
        height: 720
        FastBlur {
            opacity: 0.0
            anchors.fill: texts
            source: texts
            radius: 4
        }
        Item {
            opacity: 1.0
            id: texts
            anchors.fill: parent
            Column {
                anchors.bottom: parent.bottom
                anchors.left: parent.left
                ShadowText {
                    id: triangleCountText
                    text:"triangle count: 0"
                }
            }
        }
    }
    DrawRT {
        visible: bDebugTexts
        enabled: bDebugTexts
        textureItem: infoText
        flip: false
    }
}
